<?php

// ====================================================================================
// STYLES: echo global de <style> con todas las clases del chat
// ====================================================================================
add_action("wp_head", function () { 
   if (is_admin()) { return; } // evita cargarlos en /wp-admin
?> 
<style id="soc-chat-styles">
    
/*Wrap de todo el chatlist*/    
.soc-chatlist-wrap { 
    margin: 0; 
}
    
    /* Lista de chats del usuario, el ul */
    .soc-chatlist { 
        list-style: none; 
        padding-left: 0; 
    }
        /* chats del usuario, el li */
        .soc-thread-item { 
            display: flex;                 /* hace que el <a> sea un item flexible */
            align-items: center;           /* centra verticalmente */
            gap: 10px;                      /* separación entre elementos en la fila */
            flex-wrap: wrap;               /* permite que hint y thread bajen a la siguiente línea */
            margin-bottom: 10px;
            background-color: white;
            padding: 12px 24px;
            border-radius: 3px;
        }
        /*Last message*/
        .soc-last{
            font-size: 10px; 
            color: gray;             
        }
        .soc-linkpost{
            color: var(--e-global-color-lprimary1);
            font-weight: bold;
        }
        /*Last message*/
        .soc-open-chat{
            color: var(--e-global-color-lcolor5);
            background-color: var(--e-global-color-lprimary1);
            padding: 10px 20px;
            border-radius: 3px;                            
        }
        /* empujar el enlace "Read" a la derecha */
        .soc-thread-item .soc-open-chat{
          margin-left: auto;             /* ocupa el espacio restante hacia la derecha */
          white-space: nowrap;           /* evita que se parta en dos líneas */
        }
        /* que hint y el contenedor del chat ocupen toda la fila siguiente */
        .soc-thread-item .soc-hint,
        .soc-thread-item .soc-chat-thread{
          flex: 1 0 100%;                /* forzar a nueva línea y a 100% */
        }
            /*wrap de toda la conversacion, mensajes + form*/    
            .soc-chat-wrap {                 
            }
                /*titulo de la conversación (dice ahora "chat: from ↔ to")*/
                .soc-chat-header { 
                    display: none; /*qie ni se vea*/
                }
                    /*titulo de la conversación (dice ahora "chat:")*/
                    .soc-chat-header strong { 
                        margin-right: 6px; 
                    }
                    /*de quien para quien (dice ahora "from ↔ to")*/
                    .soc-chat-parties { }

                /*Para cuando es mensaje directo, le pones fondo y padding en elementor o donde lo pongas*/
                /*El contenedor de los mensajes*/
                .soc-chat-messages {
                    max-height: 360px;
                    overflow: auto;
                    border: 1px solid #ddd;
                    margin-top: 20px;
                    padding: 10px;
                }
                .soc-chat-messages:empty { display: none; }/*no se vea la caja sin mensajes en chat nuevos principalmente*/

                    /*El mensaje*/
                    .soc-msg {
                        /* El HTML trae estilos inline, aquí solo marcamos el modelo de caja */
                        display: flex;                 /* Para poder alinear izquierda/derecha */
                        flex-direction: column;        /* Meta arriba, burbuja abajo */
                        /*gap: 4px;                      /* Separación meta/burbuja */
                        padding: 10px 10px 10px 0;/**/
                        /*border-bottom: 1px solid #eee;/**/
                    }
                    /*De y para*/
                    /* Mensajes enviados por "from" → derecha */
                    .soc-from { 
                        align-items: flex-end;
                        /*text-align: right;/**/
                        /*color: darkgray; /**/
                    }
                    /* Mensajes recibidos → izquierda */
                    .soc-to { 
                        align-items: flex-start;
                        /*color: black; /**/
                    }
                        /*el timestamp y quien escribe*/
                        .soc-meta { 
                            font-size: 10px; 
                            color: gray; 
                        }
                        /*el mensaje en si, tipo burbuja del text */
                        .soc-text{
                            margin-top: 10px; 
                            display: inline-block;         /* Evita width:100% del block normal */
                            background: var( --e-global-color-lcolor1 );           /* fondo la burbuja */
                            color: var(--e-global-color-lcolor5);                   /* Texto legible */
                            padding: 8px 16px;             /* Relleno de la burbuja */
                            border-radius: 12px;           /* Esquinas redondeadas */
                            max-width: 90%;                /* Tope: no más de 3/4 del ancho */
                            width: auto;                   /* Lo que ocupe el contenido */
                            box-sizing: border-box;        /* Padding dentro del ancho */
                            white-space: pre-wrap;         /* Respeta saltos de línea */
                            word-wrap: break-word;         /* Romper palabras largas */
                        }
                        .least .soc-text     { background: green; } /* usuario con id == menor del par para chatadmin*/
                        .greatest .soc-text  { background: blue; } /* usuario con id == mayor del par para chatadmin */
                        .isadmin .soc-text  { background: red; } /* usuario con id == mayor del par para chatadmin */
    
                        /*los adjuntos*/
                        .soc-file { margin-top: 20px; } 
                        .soc-file a { 
                            /*text-decoration: underline; 
                            color: blue;/**/
                            color: var(--e-global-color-lcolor5);
                            background-color: var(--e-global-color-lprimary1);
                            padding: 10px 20px;
                            border-radius: 3px;                            
                        }

                /*el form del chat*/
                .soc-chat-form {
                    display: flex;
                    gap: 10px;
                    align-items: flex-start;
                }
                .soc-chat-form textarea { /*text area*/
                    resize: vertical; /* bloquea el resize horizontal */
                    flex: 1; 
                    width: 100%; 
                    background-color: #eef1f3;
                    padding: 10px;
                }
                .soc-chat-form input[type="file"] {  /*subir attachment*/
                    max-width: 220px; 
                }
                /* ocultamos el input real y uno con estilo*//*subir attachment*/
                .custom-file-label {
                    color: var(--e-global-color-lcolor5);
                    background-color: var(--e-global-color-lprimary1);
                    padding: 12px 24px;
                    border-radius: 3px;
                    cursor: pointer;
                    display: inline-block;
                    display: none ; /*Desactivado mientras apple aprueba*/
                }
                .custom-file-input { display: none ; }
    
                .soc-chat-form button { /*boton de enviar*/
                    color: var( --e-global-color-lcolor1 );
                    background-color: var( --e-global-color-lprimary2 );
                    padding: 12px 24px;
                    border-radius: 3px;                            
                }
                .soc-chat-form button:hover { 
                    color: var(--e-global-color-lcolor5);
                }
    
                /* distribución vertical del formulario de chat en móvil */
                @media (max-width: 900px){
                  .soc-chat-form{
                    /* El form ya es flex; aquí lo apilamos */
                    flex-direction: column;           /* elementos uno debajo del otro */
                    align-items: stretch !important;  /* que ocupen todo el ancho */
                  }
                  .soc-chat-form textarea{
                    width: 100%;                      /* asegurar 100% */
                  }
                  .soc-chat-form input[type="file"]{
                    max-width: 100%;       /* quitar límite de 220px en móvil */
                  }
                  .soc-chat-form button{
                    width: 100%;                      /* botón a 100% */
                  }
                  .soc-last{  
                      display: none; /*que no se vea en movil*/ 
                  }
                }
                /*O por si usas el widget en un div angosto como en una columna y quieres que agarre el look movil, solo pon
                la clase .angosto en un div padre del shortcode*/
                .angosto .soc-chat-form{
                    /* El form ya es flex; aquí lo apilamos */
                    flex-direction: column;           /* elementos uno debajo del otro */
                    align-items: stretch !important;  /* que ocupen todo el ancho */
                  }
                .angosto .soc-chat-form textarea{
                    width: 100%;                      /* asegurar 100% */
                    margin-top: 20px;
                }
                .soc-chat-form textarea{
                    margin-top: 10px;
                }
                .angosto .soc-chat-form input[type="file"]{
                    max-width: 100%;       /* quitar límite de 220px en móvil */
                  }
                .angosto .soc-chat-form button{
                    width: 100%;                      /* botón a 100% */
                  }
                .angosto .soc-last{  
                      display: none; /*que no se vea en movil*/ 
                  }

/*Boton de reportar*/
.soc-report-btn {
    padding: 12px 24px;
    width: 100% ;
    background-color: var( --e-global-color-d0db4b0 ) ;
    fill: var( --e-global-color-lcolor5 ) ;
    color: var( --e-global-color-lcolor5 ) ;
}
.soc-report-btn:hover {
    color: var( --e-global-color-lprimary2 ) ;
}
.soc-reported-note{
    margin-top: 10px;
    padding: 10px 20px;
    border-radius: 3px;                            
    background-color: var( --e-global-color-d0db4b0 ) ;
    fill: var( --e-global-color-lcolor5 ) ;
    color: var( --e-global-color-lcolor5 ) ;
    margin-left: auto;             /* ocupa el espacio restante hacia la derecha */
    white-space: nowrap;           /* evita que se parta en dos líneas */
}    
/*Animación de mensajes no leidos*/
@keyframes socBlink { 
    0%{background:transparent;} 
    50%{background: pink;} 
    100%{background:transparent;} }
.soc-thread-item.soc-new { 
    animation: socBlink 1s linear infinite; 
}

</style>
<?php });
